#extension GL_EXT_gpu_shader4 : enable

attribute vec4 position; 
attribute vec2 texcoord; 
uniform mat4 viewproj; 
uniform mat4 view;
uniform mat4 tview;
uniform mat4 proj;
uniform vec3 eyePos; 

uniform float pSize;
uniform float time;
uniform float tracks[32];
varying vec2 otc; 
varying vec4 viewpos; 
varying float size; 
varying float fogCoef; 
varying float midCoef; 
varying vec3 opos; 

float fogFar = 2000;

void main()
{
	vec4 center = vec4(texcoord.xy-vec2(.5), 0.0, 1.0); 
	size =  pSize*75.0;//3.0*abs(4.*sin(position.y*.01+position.x*.01+time*3.51)+position.w*.3f+.7f);
	vec4 bboard = size*(center.x*tview[0]+center.y*tview[1]);
	vec4 newPos = vec4(bboard.xyz+position.xyz, 1.0);
	gl_Position = proj*(vec4(0,0, .0,0)+view*newPos);

	//sphere output
	viewpos = view*newPos;
	otc = texcoord-.50;
	otc*= 3.5; 
	opos = newPos;

	fogFar = tracks[25];
	fogCoef = clamp( 1.0-(length(eyePos-position.xyz)/fogFar ), 0.0, 1.0);
	fogCoef = 1.0-clamp( pow(fogCoef*1.51, 1.0), 0.f, 1.0);
	size *= .5;

	midCoef = clamp(length(position.xyz)/tracks[26], 0.0, 1.0);
	midCoef *= midCoef;

	//midCoef = 1.0;
	//fogCoef = 1.0;
}


//FRAGMENT
#version 420
//#extension GL_ARB_conservative_depth : enable
//#extension GL_NV_shadow_samplers_cube : enable

uniform mat4 proj;
in vec2 otc;
in vec4 viewpos;
in float size;
in float fogCoef;
in float midCoef; 
in vec3 opos;
uniform mat4 tview;
uniform vec3 eyePos;

uniform samplerCube Texture0; 
uniform samplerCube Texture1;  //r
uniform sampler2D Texture2; //bg
uniform sampler2D Texture3; //things
uniform samplerCube Texture4; // fine Ref 

uniform float tracks[32];
out vec4 outputColor;

void main() {

	// compute correct sphere depth
	float sphere_size = size;
	vec3 cameraPlanePos = vec3(otc*sphere_size, 0.0) + viewpos.xyz;
	vec3 rayDir = normalize(cameraPlanePos);
	float B= 2.0*dot(rayDir, -viewpos.xyz);
	float C= dot(viewpos.xyz, viewpos.xyz) - (sphere_size*sphere_size);
	float det = (B*B)-(4*C);
	
	if(det < 0.00)
		discard;

	float sqrtDet = sqrt(det);
	float posT = (-B + sqrtDet)/2;
	float negT = (-B - sqrtDet)/2;
	float intersectT = min(posT, negT);
	vec3 cameraPos = rayDir * intersectT;
	vec3 cameraNormal = normalize(cameraPos - viewpos.xyz);

	//Set the depth based on the new cameraPos.
	vec4 clipPos = proj * vec4(cameraPos, 1.0);
	float ndcDepth = clipPos.z / clipPos.w;
	float clipDepth = ((gl_DepthRange.diff * ndcDepth) + gl_DepthRange.near + gl_DepthRange.far) / 2.0;
	gl_FragDepth = clipDepth;


	//compute vectors
	vec3 wn = normalize((tview*vec4(cameraNormal, 1.0)).xyz);
	vec3 vdir = normalize(eyePos.xyz-(viewpos.xyz+cameraNormal*size));
	vec3 rvdir = normalize(eyePos-(opos-wn*size));
	vec3 rdir = normalize( reflect(rvdir, wn));
	rdir.y = -rdir.y;
	rdir.z = -rdir.z;
	rdir.x = -rdir.x;
	rdir = normalize( reflect(-rvdir,wn));

	//sample textures
	vec4 ao = 1.-clamp(texture2D(Texture3, gl_FragCoord.xy/vec2(2560, 1440))-.5, vec4(0.f), vec4(1.f)); // <-------------------------------------- fix fix
	vec4 bg = texture2D(Texture2, gl_FragCoord.xy/vec2(2560, 1440)); // <-------------------------------------- fix fix
	vec4 dif_t = texture(Texture1, normalize(rdir), 0)+2.0*texture(Texture1, normalize(wn), 0);
	vec4 ref_t = 2.0*(texture(Texture4, rdir, 1.0)-.5);//*1.0*pow(texture(Texture0, rdir, 1.0), vec4(15));;
	dif_t = .25*tracks[24]*pow(dif_t, vec4(tracks[10]-1.8));

	// compute shading
	float dif = dot(cameraNormal, vec3(0, 0,1 ));
	float fres = 1.0-pow(dif*1.250, 2.0);//normalize(cameraPlanePos);//dif*dif;

	float fresnel1 = 1.0-1.00*clamp( 0.999000*pow(abs(dot(cameraNormal, normalize(cameraPos))), .006125000), 0., 1.0);
	float fresnel2 = 1.0-1.00*clamp( 0.999000*pow(abs(dot(cameraNormal, normalize(cameraPos))), .02125000), 0., 1.0);
	


	//diffuse
	outputColor = .0035+.25*dif_t*dif_t+fresnel1*fresnel1*20.0;

	//rimlight
	//outputColor += 3.0*ref_t*vec4(fresnel1*fresnel1*150.0);
	outputColor += vec4(5.0*dif_t*fresnel1);

	//ref_t = pow(ref_t*(1.0-fogCoef), vec4(abs(tracks[10]+0.0)));  //has falloff
	//outputColor += .5*max(vec4(0), (ref_t)*(1-fogCoef));
	outputColor += .5*max(vec4(0), ref_t);

	//outputColor = clamp(bg*vec4(1000.0*fresnel2*fresnel2), 0., 1.);

	//vao 
	outputColor *= (.3+.7*ao*ao);

	//fog
	outputColor = mix(outputColor, bg, midCoef);
	outputColor = mix(outputColor, bg, fogCoef);

	//outputColor = bg;//pow(bg, vec4(1.0/2.2));

	outputColor = vec4(wn, 1.0);
	return; 

}
